/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.LesDTOs.RecommandationAuteurDTO;
import com.notrecontinent.webapi.LesDTOs.RecommandationDTO;
import com.notrecontinent.webapi.dto.ArticleWordpress;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Categorie;
import com.notrecontinent.webapi.entities.Recommandation;
import com.notrecontinent.webapi.mapstruct.RecommandationMapper;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
public class RecommandationService {
    @Value(value="${parametre.lien.recommandation}")
    private Long param;
    @Autowired
    private RecommandationMapper recommandationMapper;
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private JavaMailSender mailSender;
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    @Transactional
    @Scheduled(cron="0 45 22 * * *", zone="GMT")
    public void SelectionnerArticleM\u00e9t\u00e9o() {
        List amis = this.auteurRepository.findBycentresdinteretsContainingElement("M\u00e9t\u00e9o");
        if (!amis.isEmpty()) {
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Categorie categorie : categories) {
                if (!categorie.getName().equals("M\u00e9t\u00e9o")) continue;
                idCategorie = categorie.getId();
                break;
            }
            String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link&status=publish&categories=" + idCategorie + "&per_page=1&orderby=date&order=desc";
            ResponseEntity responseEntity = this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]);
            String lien = ((ArticleWordpress[])responseEntity.getBody())[0].getLink();
            String titre = ((ArticleWordpress[])responseEntity.getBody())[0].getTitle().getRendered().replace("&rsquo;", "'");
            for (Auteur ami : amis) {
                Recommandation recommandation1 = this.recommandationRepository.findByParametre(this.param);
                if (recommandation1 != null) {
                    Recommandation recommandation2 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation2.getParametre() + 1L;
                }
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation = new Recommandation();
                recommandation.setParametre(this.param);
                recommandation.setCategoriearticle("M\u00e9t\u00e9o");
                recommandation.setLienrecommandation(lienRecommandation);
                recommandation.setAuteurid(ami.getId());
                recommandation.setDateenvoi(new Date());
                recommandation.setEstenvoyer(Boolean.valueOf(false));
                recommandation.setEstcliquer(Boolean.valueOf(false));
                recommandation.setLienarticle(lien);
                recommandation.setTitrearticle(titre);
                recommandation.setNomami(ami.getFirst_name());
                if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                    recommandation.setCompte(ami.getNumwhatsapp().replace("|", ""));
                    recommandation.setEstenvoyerpar("WhatsApp");
                } else if (ami.getEmail() != null && !ami.getEmail().equals("")) {
                    recommandation.setCompte(ami.getEmail());
                    recommandation.setEstenvoyerpar("email");
                }
                this.recommandationRepository.save((Object)recommandation);
                this.param = this.param + 1L;
            }
        }
    }

    @Transactional
    @Scheduled(cron="0 0 23 * * *", zone="GMT")
    public void EnvoyerArticleM\u00e9t\u00e9o() throws MessagingException, IOException {
        List recommandations = this.recommandationRepository.findByCategoriearticleAndEstenvoyer("M\u00e9t\u00e9o", Boolean.valueOf(false));
        if (!recommandations.isEmpty()) {
            this.EnvoyerRecommandations(recommandations);
        }
    }

    @Transactional
    @Scheduled(cron="0 2 6 * * *", zone="GMT")
    public void EnvoyerPremierEnvoi() throws MessagingException, IOException {
        List recommandations = this.recommandationRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!recommandations.isEmpty()) {
            this.EnvoyerRecommandations(recommandations);
        }
    }

    @Transactional
    @Scheduled(cron="0 57 8 * * *", zone="GMT")
    public void EnvoyerSecondEnvoi() throws MessagingException, IOException {
        List recommandations = this.recommandationRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!recommandations.isEmpty()) {
            this.EnvoyerRecommandations(recommandations);
        }
    }

    @Transactional
    @Scheduled(cron="0 46 11 * * *", zone="GMT")
    public void EnvoyerTroisiemeEnvoi() throws MessagingException, IOException {
        List recommandations = this.recommandationRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!recommandations.isEmpty()) {
            this.EnvoyerRecommandations(recommandations);
        }
    }

    @Transactional
    @Scheduled(cron="0 4 14 * * *", zone="GMT")
    public void EnvoyerQuatriemeEnvoi() throws MessagingException, IOException {
        List recommandations = this.recommandationRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!recommandations.isEmpty()) {
            this.EnvoyerRecommandations(recommandations);
        }
    }

    @Transactional
    @Scheduled(cron="0 9 17 * * *", zone="GMT")
    public void EnvoyerCinquiemeEnvoi() throws MessagingException, IOException {
        List recommandations = this.recommandationRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!recommandations.isEmpty()) {
            this.EnvoyerRecommandations(recommandations);
        }
    }

    public void EnvoyerRecommandations(List<Recommandation> recommandations) throws MessagingException, IOException {
        if (!recommandations.isEmpty()) {
            for (Recommandation recommandation : recommandations) {
                if (recommandation.getEstenvoyerpar() == null || recommandation.getEstenvoyerpar().equals("WhatsApp") || !recommandation.getEstenvoyerpar().equals("email")) continue;
                MimeMessage message = this.mailSender.createMimeMessage();
                MimeMessageHelper helper = new MimeMessageHelper(message, true);
                String lien = recommandation.getLienrecommandation();
                String titre = recommandation.getTitrearticle();
                String body = "<p>Bonjour cher(ch\u00e8re) " + recommandation.getNomami() + ", </p>";
                body = body + "<p>Nous vous recommandons de lire l'article ci-dessous :  </p>";
                body = body + "<p><a href='" + lien + "' >" + titre + "</a></p>";
                helper.setFrom("sender@parlerlibrement.com");
                helper.setTo(recommandation.getCompte());
                helper.setSubject("Nouvelle recommandation");
                helper.setText(body, true);
                this.mailSender.send(message);
                System.out.println("recommandation envoy\u00e9e");
                recommandation.setEstenvoyer(Boolean.valueOf(true));
            }
            this.recommandationRepository.saveAll(recommandations);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Scheduled(cron="0 45 5 * * *", zone="GMT")
    public void S\u00e9lectionnerPremierEnvoi() {
        List amisHoroscope = this.auteurRepository.findBycentresdinteretsContainingElement("Horoscope");
        List amisNonHoroscope = this.auteurRepository.findBycentresdinteretsIsNotNullAndNotContainingElement("Horoscope");
        if (!amisHoroscope.isEmpty() || !amisNonHoroscope.isEmpty()) {
            Random random = new Random();
            int randomNumber = random.nextInt(10);
            LocalDateTime currentDateTime = LocalDateTime.now();
            LocalDateTime modifiedDateTime = currentDateTime.withHour(6).withMinute(randomNumber).withSecond(0).withNano(0);
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            if (!amisHoroscope.isEmpty()) {
                for (Categorie categorie : categories) {
                    if (!categorie.getName().equals("Horoscope")) continue;
                    idCategorie = categorie.getId();
                    break;
                }
                String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link&status=publish&categories=" + idCategorie + "&per_page=1&orderby=date&order=desc";
                ResponseEntity responseEntity = this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]);
                String lien = ((ArticleWordpress[])responseEntity.getBody())[0].getLink();
                String titre = ((ArticleWordpress[])responseEntity.getBody())[0].getTitle().getRendered().replace("&rsquo;", "'");
                for (Auteur ami : amisHoroscope) {
                    Recommandation recommandation = this.recommandationRepository.findByParametre(this.param);
                    if (recommandation != null) {
                        Recommandation recommandation2 = this.recommandationRepository.findFirstByOrderByIdDesc();
                        this.param = recommandation2.getParametre() + 1L;
                    }
                    Object lienRecommandation = "https://lk.notrecontinent.com/?p=";
                    lienRecommandation = (String)lienRecommandation + lien.split("notrecontinent.com/")[1];
                    lienRecommandation = (String)lienRecommandation + this.param;
                    Recommandation recommandation2 = new Recommandation();
                    recommandation2.setParametre(this.param);
                    recommandation2.setCategoriearticle("Horoscope");
                    recommandation2.setLienrecommandation((String)lienRecommandation);
                    recommandation2.setAuteurid(ami.getId());
                    recommandation2.setDateenvoi((Date)Timestamp.valueOf(modifiedDateTime));
                    recommandation2.setEstenvoyer(Boolean.valueOf(false));
                    recommandation2.setEstcliquer(Boolean.valueOf(false));
                    recommandation2.setLienarticle(lien);
                    recommandation2.setTitrearticle(titre);
                    recommandation2.setNomami(ami.getFirst_name());
                    if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(ami.getNumwhatsapp().replace("|", ""));
                        recommandation2.setEstenvoyerpar("WhatsApp");
                    } else if (ami.getEmail() != null && !ami.getEmail().equals("")) {
                        recommandation2.setCompte(ami.getEmail());
                        recommandation2.setEstenvoyerpar("email");
                    }
                    this.recommandationRepository.save((Object)recommandation2);
                    this.param = this.param + 1L;
                }
            }
            if (!amisNonHoroscope.isEmpty()) {
                for (Auteur auteur : amisNonHoroscope) {
                    Recommandation recommandation;
                    List centredinterets = auteur.getCentresdinterets();
                    centredinterets = centredinterets.stream().filter(c -> !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                    ArrayList<ArticleWordpress> articleWordpresses = new ArrayList<ArticleWordpress>();
                    for (int i = 0; i < centredinterets.size(); ++i) {
                        for (Categorie categorie : categories) {
                            if (!categorie.getName().equals(centredinterets.get(i))) continue;
                            idCategorie = categorie.getId();
                            break;
                        }
                        String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + idCategorie + "&per_page=3&orderby=date&order=desc";
                        ArticleWordpress[] articleWordpressArray = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                        articleWordpresses.addAll(Arrays.asList(articleWordpressArray));
                    }
                    articleWordpresses.removeIf(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) != null);
                    if (articleWordpresses.isEmpty()) continue;
                    ArticleWordpress articleWordpress = new ArticleWordpress();
                    int i = 0;
                    LocalDateTime localDateTime = LocalDateTime.parse(((ArticleWordpress)articleWordpresses.get(0)).getDate());
                    for (ArticleWordpress articleWordpress2 : articleWordpresses) {
                        void var16_28;
                        LocalDateTime currentDate = LocalDateTime.parse(articleWordpress2.getDate());
                        if (!currentDate.isAfter((ChronoLocalDateTime<?>)var16_28)) continue;
                        LocalDateTime localDateTime2 = currentDate;
                        i = articleWordpresses.indexOf(articleWordpress2);
                    }
                    articleWordpress = (ArticleWordpress)articleWordpresses.get(i);
                    String categorieArticle = "";
                    for (Categorie categorie : categories) {
                        if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                        System.out.println(categorie.getName());
                        categorieArticle = categorie.getName();
                        break;
                    }
                    if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                        Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                        this.param = recommandation1.getParametre() + 1L;
                    }
                    String lien = articleWordpress.getLink();
                    String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                    String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                    lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                    lienRecommandation = lienRecommandation + this.param;
                    Recommandation recommandation2 = new Recommandation();
                    recommandation2.setParametre(this.param);
                    recommandation2.setCategoriearticle(categorieArticle);
                    recommandation2.setLienrecommandation(lienRecommandation);
                    recommandation2.setAuteurid(auteur.getId());
                    recommandation2.setDateenvoi((Date)Timestamp.valueOf(modifiedDateTime));
                    recommandation2.setEstenvoyer(Boolean.valueOf(false));
                    recommandation2.setEstcliquer(Boolean.valueOf(false));
                    recommandation2.setLienarticle(lien);
                    recommandation2.setTitrearticle(titre);
                    recommandation2.setNomami(auteur.getFirst_name());
                    if (auteur.getNumwhatsapp() != null && !auteur.getNumwhatsapp().equals("")) {
                        recommandation2.setCompte(auteur.getNumwhatsapp().replace("|", ""));
                        recommandation2.setEstenvoyerpar("WhatsApp");
                    } else if (auteur.getEmail() != null && !auteur.getEmail().equals("")) {
                        recommandation2.setCompte(auteur.getEmail());
                        recommandation2.setEstenvoyerpar("email");
                    }
                    this.recommandationRepository.save((Object)recommandation2);
                    this.param = this.param + 1L;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Scheduled(cron="0 35 8 * * *", zone="GMT")
    public void S\u00e9lectionnerSecondEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            Random random = new Random();
            int randomNumber = random.nextInt(10);
            LocalDateTime currentDateTime = LocalDateTime.now();
            LocalDateTime modifiedDateTime = currentDateTime.withHour(8).withMinute(50 + randomNumber).withSecond(0).withNano(0);
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                ArrayList<ArticleWordpress> articleWordpresses = new ArrayList<ArticleWordpress>();
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        idCategorie = categorie.getId();
                        break;
                    }
                    String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + idCategorie + "&per_page=3&orderby=date&order=desc";
                    ArticleWordpress[] articleWordpressArray = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                    articleWordpresses.addAll(Arrays.asList(articleWordpressArray));
                }
                articleWordpresses.removeIf(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) != null);
                if (articleWordpresses.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime localDateTime = LocalDateTime.parse(((ArticleWordpress)articleWordpresses.get(0)).getDate());
                for (ArticleWordpress articleWordpress2 : articleWordpresses) {
                    void var15_21;
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress2.getDate());
                    if (!currentDate.isAfter((ChronoLocalDateTime<?>)var15_21)) continue;
                    LocalDateTime localDateTime2 = currentDate;
                    i = articleWordpresses.indexOf(articleWordpress2);
                }
                articleWordpress = (ArticleWordpress)articleWordpresses.get(i);
                String categorieArticle = "";
                for (Categorie categorie : categories) {
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setDateenvoi((Date)Timestamp.valueOf(modifiedDateTime));
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                    recommandation2.setCompte(ami.getNumwhatsapp().replace("|", ""));
                    recommandation2.setEstenvoyerpar("WhatsApp");
                } else if (ami.getEmail() != null && !ami.getEmail().equals("")) {
                    recommandation2.setCompte(ami.getEmail());
                    recommandation2.setEstenvoyerpar("email");
                }
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Scheduled(cron="0 15 11 * * *", zone="GMT")
    public void S\u00e9lectionnerTroisiemeEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            Random random = new Random();
            int randomNumber = random.nextInt(10);
            LocalDateTime currentDateTime = LocalDateTime.now();
            LocalDateTime modifiedDateTime = currentDateTime.withHour(11).withMinute(30 + randomNumber).withSecond(0).withNano(0);
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                ArrayList<ArticleWordpress> articleWordpresses = new ArrayList<ArticleWordpress>();
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        idCategorie = categorie.getId();
                        break;
                    }
                    String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + idCategorie + "&per_page=3&orderby=date&order=desc";
                    ArticleWordpress[] articleWordpressArray = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                    articleWordpresses.addAll(Arrays.asList(articleWordpressArray));
                }
                articleWordpresses.removeIf(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) != null);
                if (articleWordpresses.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime localDateTime = LocalDateTime.parse(((ArticleWordpress)articleWordpresses.get(0)).getDate());
                for (ArticleWordpress articleWordpress2 : articleWordpresses) {
                    void var15_21;
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress2.getDate());
                    if (!currentDate.isAfter((ChronoLocalDateTime<?>)var15_21)) continue;
                    LocalDateTime localDateTime2 = currentDate;
                    i = articleWordpresses.indexOf(articleWordpress2);
                }
                articleWordpress = (ArticleWordpress)articleWordpresses.get(i);
                String categorieArticle = "";
                for (Categorie categorie : categories) {
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setDateenvoi((Date)Timestamp.valueOf(modifiedDateTime));
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                    recommandation2.setCompte(ami.getNumwhatsapp().replace("|", ""));
                    recommandation2.setEstenvoyerpar("WhatsApp");
                } else if (ami.getEmail() != null && !ami.getEmail().equals("")) {
                    recommandation2.setCompte(ami.getEmail());
                    recommandation2.setEstenvoyerpar("email");
                }
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Scheduled(cron="0 45 13 * * *", zone="GMT")
    public void S\u00e9lectionnerQuatriemeEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            Random random = new Random();
            int randomNumber = random.nextInt(10);
            LocalDateTime currentDateTime = LocalDateTime.now();
            LocalDateTime modifiedDateTime = currentDateTime.withHour(14).withMinute(randomNumber).withSecond(0).withNano(0);
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                ArrayList<ArticleWordpress> articleWordpresses = new ArrayList<ArticleWordpress>();
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        idCategorie = categorie.getId();
                        break;
                    }
                    String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + idCategorie + "&per_page=3&orderby=date&order=desc";
                    ArticleWordpress[] articleWordpressArray = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                    articleWordpresses.addAll(Arrays.asList(articleWordpressArray));
                }
                articleWordpresses.removeIf(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) != null);
                if (articleWordpresses.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime localDateTime = LocalDateTime.parse(((ArticleWordpress)articleWordpresses.get(0)).getDate());
                for (ArticleWordpress articleWordpress2 : articleWordpresses) {
                    void var15_21;
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress2.getDate());
                    if (!currentDate.isAfter((ChronoLocalDateTime<?>)var15_21)) continue;
                    LocalDateTime localDateTime2 = currentDate;
                    i = articleWordpresses.indexOf(articleWordpress2);
                }
                articleWordpress = (ArticleWordpress)articleWordpresses.get(i);
                String categorieArticle = "";
                for (Categorie categorie : categories) {
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setDateenvoi((Date)Timestamp.valueOf(modifiedDateTime));
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                    recommandation2.setCompte(ami.getNumwhatsapp().replace("|", ""));
                    recommandation2.setEstenvoyerpar("WhatsApp");
                } else if (ami.getEmail() != null && !ami.getEmail().equals("")) {
                    recommandation2.setCompte(ami.getEmail());
                    recommandation2.setEstenvoyerpar("email");
                }
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @Scheduled(cron="0 45 16 * * *", zone="GMT")
    public void S\u00e9lectionnerCinquiemeEnvoi() {
        List amis = this.auteurRepository.findBycentresdinteretsIsNotNull();
        if (!amis.isEmpty()) {
            Random random = new Random();
            int randomNumber = random.nextInt(10);
            LocalDateTime currentDateTime = LocalDateTime.now();
            LocalDateTime modifiedDateTime = currentDateTime.withHour(17).withMinute(randomNumber).withSecond(0).withNano(0);
            List<Object> categories = Arrays.asList((Object[])this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/categories?_fields=id,name&per_page=100", HttpMethod.GET, null, Categorie[].class, new Object[0]).getBody());
            long idCategorie = 1L;
            for (Auteur ami : amis) {
                Recommandation recommandation;
                List centredinterets = ami.getCentresdinterets();
                centredinterets = centredinterets.stream().filter(c -> !c.equals("Horoscope") && !c.equals("M\u00e9t\u00e9o")).collect(Collectors.toList());
                ArrayList<ArticleWordpress> articleWordpresses = new ArrayList<ArticleWordpress>();
                for (int i = 0; i < centredinterets.size(); ++i) {
                    for (Categorie categorie : categories) {
                        if (!categorie.getName().equals(centredinterets.get(i))) continue;
                        idCategorie = categorie.getId();
                        break;
                    }
                    String BASE_URL = "https://sn.notrecontinent.com/wp-json/wp/v2/posts?_fields=title,link,date,categories&status=publish&categories=" + idCategorie + "&per_page=3&orderby=date&order=desc";
                    ArticleWordpress[] articleWordpressArray = (ArticleWordpress[])this.restTemplate.exchange(BASE_URL, HttpMethod.GET, null, ArticleWordpress[].class, new Object[0]).getBody();
                    articleWordpresses.addAll(Arrays.asList(articleWordpressArray));
                }
                articleWordpresses.removeIf(a -> this.recommandationRepository.findFirstByLienarticleAndAuteuridOrderByDateCreationDesc(a.getLink(), ami.getId()) != null);
                if (articleWordpresses.isEmpty()) continue;
                ArticleWordpress articleWordpress = new ArticleWordpress();
                int i = 0;
                LocalDateTime localDateTime = LocalDateTime.parse(((ArticleWordpress)articleWordpresses.get(0)).getDate());
                for (ArticleWordpress articleWordpress2 : articleWordpresses) {
                    void var15_21;
                    LocalDateTime currentDate = LocalDateTime.parse(articleWordpress2.getDate());
                    if (!currentDate.isAfter((ChronoLocalDateTime<?>)var15_21)) continue;
                    LocalDateTime localDateTime2 = currentDate;
                    i = articleWordpresses.indexOf(articleWordpress2);
                }
                articleWordpress = (ArticleWordpress)articleWordpresses.get(i);
                String categorieArticle = "";
                for (Categorie categorie : categories) {
                    if (!Objects.equals(categorie.getId(), articleWordpress.getCategories()[0])) continue;
                    System.out.println(categorie.getName());
                    categorieArticle = categorie.getName();
                    break;
                }
                if ((recommandation = this.recommandationRepository.findByParametre(this.param)) != null) {
                    Recommandation recommandation1 = this.recommandationRepository.findFirstByOrderByIdDesc();
                    this.param = recommandation1.getParametre() + 1L;
                }
                String lien = articleWordpress.getLink();
                String titre = articleWordpress.getTitle().getRendered().replace("&rsquo;", "'");
                String lienRecommandation = "https://lk.notrecontinent.com/?p=";
                lienRecommandation = lienRecommandation + lien.split("notrecontinent.com/")[1];
                lienRecommandation = lienRecommandation + this.param;
                Recommandation recommandation2 = new Recommandation();
                recommandation2.setParametre(this.param);
                recommandation2.setCategoriearticle(categorieArticle);
                recommandation2.setLienrecommandation(lienRecommandation);
                recommandation2.setAuteurid(ami.getId());
                recommandation2.setDateenvoi((Date)Timestamp.valueOf(modifiedDateTime));
                recommandation2.setEstenvoyer(Boolean.valueOf(false));
                recommandation2.setEstcliquer(Boolean.valueOf(false));
                recommandation2.setLienarticle(lien);
                recommandation2.setTitrearticle(titre);
                recommandation2.setNomami(ami.getFirst_name());
                if (ami.getNumwhatsapp() != null && !ami.getNumwhatsapp().equals("")) {
                    recommandation2.setCompte(ami.getNumwhatsapp().replace("|", ""));
                    recommandation2.setEstenvoyerpar("WhatsApp");
                } else if (ami.getEmail() != null && !ami.getEmail().equals("")) {
                    recommandation2.setCompte(ami.getEmail());
                    recommandation2.setEstenvoyerpar("email");
                }
                this.recommandationRepository.save((Object)recommandation2);
                this.param = this.param + 1L;
            }
        }
    }

    @Transactional
    public List<Recommandation> getAllRecommandations() {
        return this.recommandationRepository.findAll();
    }

    public ResponseEntity<List<RecommandationAuteurDTO>> getAllRecommandationsByAmiId(Long id) throws JsonProcessingException {
        List recommandations = this.recommandationRepository.findByAuteuridOrderByEstcliquerAscDateCreationDesc(id);
        if (!recommandations.isEmpty()) {
            List recommandationAuteurDTOS = this.recommandationMapper.RecommandationsToRecommandateurAuteurDTO(recommandations);
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString((Object)recommandationAuteurDTOS);
            long contentLength = jsonString.getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)recommandationAuteurDTOS);
        }
        return null;
    }

    @Transactional
    public Recommandation AddRecommandation(Recommandation recommandation) {
        Recommandation recommandation1 = this.recommandationRepository.findByParametre(this.param);
        if (recommandation1 != null) {
            Recommandation recommandation2 = this.recommandationRepository.findFirstByOrderByIdDesc();
            this.param = recommandation2.getParametre() + 1L;
        }
        recommandation.setParametre(this.param);
        recommandation.setEstcliquer(Boolean.valueOf(false));
        recommandation.setCompte("toplayene95@gmail.com");
        recommandation.setAuteurid(Long.valueOf(11L));
        String lienrecommandation = "http://localhost:4300/";
        lienrecommandation = lienrecommandation + recommandation.getLienarticle().split("notrecontinent.com/")[1];
        lienrecommandation = lienrecommandation + recommandation.getParametre();
        recommandation.setLienrecommandation(lienrecommandation);
        Recommandation recommandation2 = (Recommandation)this.recommandationRepository.save((Object)recommandation);
        this.param = this.param + 1L;
        return recommandation2;
    }

    @Transactional
    public String UpdateStatusRecommandation(Long parametre) {
        Recommandation recommandation = this.recommandationRepository.findByParametre(parametre);
        if (recommandation != null) {
            if (!recommandation.getEstcliquer().booleanValue()) {
                recommandation.setEstcliquer(Boolean.valueOf(true));
                this.recommandationRepository.save((Object)recommandation);
            }
            return "lu";
        }
        return "non lu";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public String UpdateRecommandationStatus(List<RecommandationDTO> recommandationDTOList) {
        String response = "d\u00e9but de la mise \u00e0 jour";
        try {
            if (!recommandationDTOList.isEmpty()) {
                HashSet<RecommandationDTO> recommandationDTOSansDoublons = new HashSet<RecommandationDTO>(recommandationDTOList);
                recommandationDTOList = new ArrayList<RecommandationDTO>(recommandationDTOSansDoublons);
                List recommandations = this.recommandationRepository.findByEstenvoyerAndEstcliquer(Boolean.valueOf(true), Boolean.valueOf(false));
                if (!recommandations.isEmpty()) {
                    block5: for (Recommandation recom : recommandations) {
                        for (RecommandationDTO r : recommandationDTOList) {
                            Boolean b = recom.getLienrecommandation().equals(r.getLienrecommandation()) && String.valueOf(recom.getParametre()).equals(r.getParametre());
                            if (!b.booleanValue()) continue;
                            recom.setEstcliquer(Boolean.valueOf(true));
                            continue block5;
                        }
                    }
                }
                this.recommandationRepository.saveAll((Iterable)recommandations);
                response = "Mises \u00e0 jour effectu\u00e9es avec succ\u00e8s.";
                return response;
            }
        }
        catch (RuntimeException e) {
            System.out.println(e.getMessage());
            response = "Erreur lors de la mise \u00e0 jour.";
            return response;
        }
        finally {
            return response;
        }
    }
}

