/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi;

import java.io.IOException;
import java.text.ParseException;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.client.RestTemplate;

@EnableScheduling
@EnableJpaAuditing
@SpringBootApplication
@EnableCaching
public class NotreContinentApiApplication {
    public static void main(String[] args) throws IOException, ParseException {
        SpringApplication.run(NotreContinentApiApplication.class, (String[])args);
    }

    @PostConstruct
    void started() {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @Bean
    public BCryptPasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder(10);
    }

    @Bean
    public CacheManager cacheManager() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

