/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.Recommandation;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationAunAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PointsAmiService {
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private RecommandationAunAmiRepository recommandationAunAmiRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private BugsCronService bugsCronService;

    @Transactional
    public void getpointsFromOldRecom() {
        List recommandations = this.recommandationRepository.findByEstcliquerAndFraude(Boolean.valueOf(true), Boolean.valueOf(false));
        if (!recommandations.isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
            for (Recommandation r : recommandations) {
                r.setDateClick(r.getDateCreation());
            }
            HashSet<Long> amiids = new HashSet<Long>();
            for (Recommandation r : recommandations) {
                amiids.add(r.getAuteurid());
            }
            for (Long amiid : amiids) {
                List recommandations1 = recommandations.stream().filter(recom -> Objects.equals(recom.getAuteurid(), amiid)).collect(Collectors.toList());
                HashSet<String> moishashet = new HashSet<String>();
                for (Recommandation recommandation : recommandations1) {
                    String mois = dateFormat.format(recommandation.getDateClick());
                    moishashet.add(mois);
                }
                for (String month : moishashet) {
                    List recomsparmois = recommandations1.stream().filter(recomm -> month.equals(dateFormat.format(recomm.getDateClick()))).collect(Collectors.toList());
                    PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(month, amiid);
                    if (pointsAmi != null) {
                        pointsAmi.setNbArticlesLus(Long.valueOf(recomsparmois.size()));
                        pointsAmi.setNbPointsArticlesLus(Long.valueOf(2L * (long)recomsparmois.size()));
                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsArticlesLus() + pointsAmi.getNbPointsRecommandations()));
                        this.pointsAmiRepository.save((Object)pointsAmi);
                        continue;
                    }
                    PointsAmi p = new PointsAmi();
                    p.setNbArticlesLus(Long.valueOf(recomsparmois.size()));
                    p.setNbPointsArticlesLus(Long.valueOf(2L * (long)recomsparmois.size()));
                    p.setMois(month);
                    p.setNbPointsMois(p.getNbPointsArticlesLus());
                    p.setNbMissions(Long.valueOf(0L));
                    p.setNbPointsMissions(Long.valueOf(0L));
                    p.setNbRecommandations(Long.valueOf(0L));
                    p.setNbPointsRecommandations(Long.valueOf(0L));
                    p.setAmiId(amiid);
                    this.pointsAmiRepository.save((Object)p);
                }
            }
            this.recommandationRepository.saveAll((Iterable)recommandations);
        }
    }

    @Scheduled(cron="30 6 4 1 * *", zone="GMT")
    @Transactional
    public void updatePointsCumules() {
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                for (Auteur ami : amis) {
                    List pointsAmis = this.pointsAmiRepository.findByAmiId(ami.getId());
                    if (pointsAmis.isEmpty()) continue;
                    Long pointscumules = 0L;
                    for (PointsAmi p : pointsAmis) {
                        pointscumules = pointscumules + p.getNbPointsMois();
                    }
                    ami.setTotalPointsCumules(pointscumules);
                }
                this.auteurRepository.saveAll((Iterable)amis);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points cumul\u00e9s des comptes amis", e.getMessage());
        }
    }

    @Scheduled(cron="30 3 4 1 * *", zone="GMT")
    @Transactional
    public void updatePointsarticleslus() {
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                for (Auteur ami : amis) {
                    List recommandationList;
                    List pointsAmis = this.pointsAmiRepository.findByAmiId(ami.getId());
                    if (pointsAmis.isEmpty() || (recommandationList = this.recommandationRepository.findByEstcliquerAndAuteuridAndFraude(Boolean.valueOf(true), ami.getId(), Boolean.valueOf(false))).isEmpty()) continue;
                    for (PointsAmi p : pointsAmis) {
                        String mois = p.getMois();
                        List recommandations = recommandationList.stream().filter(r -> mois.equals(dateFormat.format(r.getDateClick()))).collect(Collectors.toList());
                        if (recommandations.isEmpty()) continue;
                        p.setNbArticlesLus(Long.valueOf(recommandations.size()));
                        p.setNbPointsArticlesLus(Long.valueOf(2L * p.getNbArticlesLus()));
                        p.setNbPointsMois(Long.valueOf(p.getNbPointsArticlesLus() + p.getNbPointsRecommandations() + p.getNbPointsMissions()));
                    }
                    this.pointsAmiRepository.saveAll((Iterable)pointsAmis);
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points des articles lus des comptes amis", e.getMessage());
        }
    }

    @Transactional
    @Scheduled(cron="15 0 4 1 * *", zone="GMT")
    public void updaterecommandationsaunami() {
        try {
            List amis = this.auteurRepository.findAmisWithCentreInterets();
            if (!amis.isEmpty()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                for (Auteur ami : amis) {
                    List recommandationAunAmisList;
                    List pointsAmis = this.pointsAmiRepository.findByAmiId(ami.getId());
                    if (pointsAmis.isEmpty() || (recommandationAunAmisList = this.recommandationAunAmiRepository.findByAmiIDAndEstenvoyerOrderByDateenvoiDesc(ami.getId(), Boolean.valueOf(true))).isEmpty()) continue;
                    for (PointsAmi p : pointsAmis) {
                        String mois = p.getMois();
                        List recommandationAunAmis = recommandationAunAmisList.stream().filter(r -> mois.equals(dateFormat.format(r.getDateCreation()))).collect(Collectors.toList());
                        if (recommandationAunAmis.isEmpty()) continue;
                        p.setNbRecommandations(Long.valueOf(recommandationAunAmis.size()));
                        p.setNbPointsRecommandations(Long.valueOf(5L * p.getNbRecommandations()));
                        p.setNbPointsMois(Long.valueOf(p.getNbPointsArticlesLus() + p.getNbPointsRecommandations() + p.getNbPointsMissions()));
                    }
                    this.pointsAmiRepository.saveAll((Iterable)pointsAmis);
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de mise \u00e0 jour des points 'Recommandations \u00e0 un ami' des comptes amis", e.getMessage());
        }
    }
}

