/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.LesDTOs.ArticleAdminDTO;
import com.notrecontinent.webapi.dto.ArticleWpDesactiver;
import com.notrecontinent.webapi.dto.AuteurWP;
import com.notrecontinent.webapi.dto.DashbordStats;
import com.notrecontinent.webapi.entities.Article;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Bugs;
import com.notrecontinent.webapi.entities.Connexion;
import com.notrecontinent.webapi.enumeration.SubdomainsPaysEnum;
import com.notrecontinent.webapi.repositories.ArticleRepository;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.ConnexionRepository;
import com.notrecontinent.webapi.services.BugService;
import com.notrecontinent.webapi.services.PhotoService;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AdminService {
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private ArticleRepository articleRepository;
    @Autowired
    private ConnexionRepository connexionRepository;
    @Autowired
    private PhotoService photoService;
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private BugService bugService;
    String userPassci = "Momar:Enpc kRrN iRmm scP5 rvzs Muul";
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    public ResponseEntity<List<Connexion>> getAllConnexion() throws JsonProcessingException {
        List connexions = this.connexionRepository.findByOrderByDateConnexionDesc();
        long contentLength = this.mapper.writeValueAsString((Object)connexions).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)connexions);
    }

    @Transactional
    public String Deconnexion(String idconnexion) throws ParseException {
        Connexion connexion = (Connexion)this.connexionRepository.findById((Object)Long.valueOf(idconnexion)).get();
        connexion.setFinSession(new Date());
        this.connexionRepository.save((Object)connexion);
        return "D\u00e9connexion r\u00e9ussie";
    }

    public ResponseEntity<List<ArticleAdminDTO>> getAllArticles() throws IOException {
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("Validation en cours");
        statusList.add("Valid\u00e9 (en ligne)");
        statusList.add("Rejet\u00e9");
        List articles = this.articleRepository.findByStatusInOrderByDateCreationDesc(statusList);
        ArrayList<ArticleAdminDTO> articlesAdmin = new ArrayList<ArticleAdminDTO>();
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                System.out.println("id de l'article: " + article.getId());
                System.out.println("image de l'article: " + article.getImage82());
                if (article.getImage82() != null) {
                    article.setImage82(this.photoService.getPhoto82(article.getImage82()));
                }
                article.setContenu("");
                ArticleAdminDTO articleAdmin = new ArticleAdminDTO();
                articleAdmin.setArticle(article);
                articleAdmin.setAuteur((Auteur)this.auteurRepository.findById((Object)article.getAuteurID()).get());
                articlesAdmin.add(articleAdmin);
            }
        }
        long contentLength = this.mapper.writeValueAsString(articlesAdmin).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(articlesAdmin);
    }

    @Transactional
    public String DeactivateArticle(String id) {
        Optional article = this.articleRepository.findById((Object)Long.valueOf(id));
        if (article.isPresent()) {
            Article article1 = (Article)article.get();
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            authHeader = article1.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
            headers.set("Authorization", authHeader);
            ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            article1.setLastStatus(article1.getStatus());
            article1.setAdesactiver(Boolean.valueOf(true));
            article1.setStatus("Rejet\u00e9");
            article1.setDatemodification(new Date());
            this.articleRepository.save((Object)article1);
        }
        return "Article d\u00e9sactiv\u00e9";
    }

    @Transactional
    public String DeactivateArticles(List<Long> ids) {
        List articles = this.articleRepository.findAllById(ids);
        if (!articles.isEmpty()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            for (Article article : articles) {
                headers = new HttpHeaders();
                authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            }
            for (Article article : articles) {
                article.setLastStatus(article.getStatus());
                article.setAdesactiver(Boolean.valueOf(true));
                article.setStatus("Rejet\u00e9");
                article.setDatemodification(new Date());
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
        return "Articles d\u00e9sactiv\u00e9s";
    }

    @Transactional
    public String ReactivateArticle(String id) {
        Optional article = this.articleRepository.findById((Object)Long.valueOf(id));
        if (article.isPresent()) {
            Article article1 = (Article)article.get();
            article1.setAreactiver(Boolean.valueOf(true));
            article1.setDatemodification(new Date());
            article1.setStatus(article1.getLastStatus());
            this.articleRepository.save((Object)article1);
        }
        return "Article r\u00e9activ\u00e9";
    }

    @Transactional
    public String ReactivateArticles(List<Long> ids) {
        List articles = this.articleRepository.findAllById(ids);
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                article.setAreactiver(Boolean.valueOf(true));
                article.setStatus(article.getLastStatus());
                article.setDatemodification(new Date());
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
        return "Articles r\u00e9activ\u00e9s";
    }

    @Transactional
    @Scheduled(cron="0 */10 * * * *")
    public void DeactivateArticlesInWP() {
        List articles = this.articleRepository.findByStatusAndAdesactiver("Rejet\u00e9", Boolean.valueOf(true));
        if (!articles.isEmpty()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            for (Article article : articles) {
                headers = new HttpHeaders();
                authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                articleWpDesactiver = new ArticleWpDesactiver();
                articleWpDesactiver.setStatus("pending");
                HttpEntity requestEntity = new HttpEntity((Object)articleWpDesactiver, (MultiValueMap)headers);
                this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/posts/" + article.getWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                article.setAdesactiver(Boolean.valueOf(false));
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
    }

    @Transactional
    @Scheduled(cron="0 */10 * * * *")
    public void ReactivateArticlesInWP() {
        List articles = this.articleRepository.findByStatusAndAreactiver("Rejet\u00e9", Boolean.valueOf(true));
        if (!articles.isEmpty()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            for (Article article : articles) {
                headers = new HttpHeaders();
                authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                articleWpDesactiver = new ArticleWpDesactiver();
                switch (article.getLastStatus()) {
                    case "Validation en cours": {
                        articleWpDesactiver.setStatus("draft");
                        break;
                    }
                    case "Valid\u00e9 (en ligne)": {
                        articleWpDesactiver.setStatus("publish");
                    }
                }
                HttpEntity requestEntity = new HttpEntity((Object)articleWpDesactiver, (MultiValueMap)headers);
                this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/posts/" + article.getWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                article.setAreactiver(Boolean.valueOf(false));
                article.setStatus(article.getLastStatus());
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
    }

    public ResponseEntity<List<Auteur>> getAllAuteur() throws JsonProcessingException {
        List auteurs = this.auteurRepository.findByOrderByDateCreationDesc();
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                auteur.setPassword("");
            }
        }
        long contentLength = this.mapper.writeValueAsString((Object)auteurs).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)auteurs);
    }

    @Transactional
    public Auteur CreateAuteur(Auteur auteur) {
        Boolean b = this.auteurRepository.existsByUsernameAndBloquerAndPays(auteur.getUsername(), Boolean.valueOf(false), auteur.getPays());
        if (b.booleanValue()) {
            return null;
        }
        AuteurWP auteurWP = new AuteurWP();
        auteurWP.setPassword(auteur.getPassword());
        auteurWP.setUsername(auteur.getUsername());
        String dateFormat = "dd/MM/yyyy";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        String today = simpleDateFormat.format(new Date());
        String emailWP = "PL-" + today + "-" + auteur.getEmail();
        auteurWP.setEmail(emailWP);
        HttpHeaders headers = new HttpHeaders();
        String authHeader = "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes());
        headers.set("Authorization", authHeader);
        HttpEntity requestEntity = new HttpEntity((Object)auteurWP, (MultiValueMap)headers);
        try {
            String response = (String)this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/users", HttpMethod.POST, requestEntity, String.class, new Object[0]).getBody();
            Long id = Long.valueOf(response.split(",")[0].split(":")[1]);
            auteur.setEmail(auteur.getUsername() + "@notrecontinent.com");
            auteur.setWordpressID(id);
            String pwd = this.bCryptPasswordEncoder.encode((CharSequence)auteur.getPassword());
            auteur.setPassword(pwd);
            auteur.setDateCreation(new Date());
            auteur.setBloquer(Boolean.valueOf(false));
            auteur.setMailenvoyer(Boolean.valueOf(false));
        }
        catch (Exception e) {
            throw new RuntimeException("Error: " + e.getMessage());
        }
        return (Auteur)this.auteurRepository.save((Object)auteur);
    }

    @Transactional
    public String UpdatePasswordAuteur(String id, String newpwd) {
        Optional auteur = this.auteurRepository.findById((Object)Long.valueOf(id));
        if (auteur.isPresent()) {
            Auteur auteur1 = (Auteur)auteur.get();
            String pwd = this.bCryptPasswordEncoder.encode((CharSequence)newpwd);
            auteur1.setPassword(pwd);
            auteur1.setDateModification(new Date());
            this.auteurRepository.save((Object)auteur1);
        }
        return "Mot de passe modifi\u00e9";
    }

    @Transactional
    public String BloquerAuteur(String id) {
        Optional auteur = this.auteurRepository.findById((Object)Long.valueOf(id));
        if (auteur.isPresent()) {
            Auteur auteur1 = (Auteur)auteur.get();
            auteur1.setBloquer(Boolean.valueOf(true));
            auteur1.setDateModification(new Date());
            this.auteurRepository.save((Object)auteur1);
        }
        return "Auteur bloqu\u00e9";
    }

    @Transactional
    public String ReactiverAuteur(String id) {
        Optional auteur = this.auteurRepository.findById((Object)Long.valueOf(id));
        if (auteur.isPresent()) {
            Auteur auteur1 = (Auteur)auteur.get();
            auteur1.setBloquer(Boolean.valueOf(false));
            auteur1.setDateModification(new Date());
            this.auteurRepository.save((Object)auteur1);
        }
        return "Auteur r\u00e9activ\u00e9";
    }

    @Transactional
    public String BloquerAuteurs(List<Long> ids) {
        List auteurs = this.auteurRepository.findAllById(ids);
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                auteur.setBloquer(Boolean.valueOf(true));
                auteur.setDateModification(new Date());
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
        return "Auteurs bloqu\u00e9s";
    }

    @Transactional
    public String ReactiverAuteurs(List<Long> ids) {
        List auteurs = this.auteurRepository.findAllById(ids);
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                auteur.setBloquer(Boolean.valueOf(false));
                auteur.setDateModification(new Date());
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
        return "Auteurs r\u00e9activ\u00e9s";
    }

    public ResponseEntity<List<DashbordStats>> getAdminDashboardStats() throws JsonProcessingException {
        List articles = this.articleRepository.findAll();
        ArrayList<DashbordStats> dashbordStats = new ArrayList<DashbordStats>();
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        if (!articles.isEmpty()) {
            for (int i = 0; i < articles.size(); ++i) {
                DashbordStats dashbordStats1 = new DashbordStats(((Article)articles.get(i)).getStatus(), format.format(((Article)articles.get(i)).getDateCreation()));
                dashbordStats.add(dashbordStats1);
            }
        }
        long contentLength = this.mapper.writeValueAsString(dashbordStats).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(dashbordStats);
    }

    public ResponseEntity<List<Article>> getAdminStatistiques() throws IOException {
        List articles = this.articleRepository.findByStatusOrderByDateCreationDesc("Valid\u00e9 (en ligne)");
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                if (article.getImage82() != null) {
                    article.setImage82(this.photoService.getPhoto82(article.getImage82()));
                }
                article.setContenu("");
            }
        }
        long contentLength = this.mapper.writeValueAsString((Object)articles).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)articles);
    }

    @Transactional
    public ResponseEntity<List<Bugs>> getAllBugs() throws JsonProcessingException {
        List bugsList = this.bugService.getAllBugs();
        long contentLength = this.mapper.writeValueAsString((Object)bugsList).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)bugsList);
    }
}

