/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.notrecontinent.webapi.LesDTOs.ArticleAuteur;
import com.notrecontinent.webapi.LesDTOs.ArticlesAuteurDTO;
import com.notrecontinent.webapi.LesDTOs.ArticlesBrouillonAuteurDTO;
import com.notrecontinent.webapi.LesDTOs.ArticlesRejetesAuteurDTO;
import com.notrecontinent.webapi.LesDTOs.ArticlesValidationEnCoursAuteurDTO;
import com.notrecontinent.webapi.LesDTOs.ArticlesValidesAuteurDTO;
import com.notrecontinent.webapi.dto.ArticleDto;
import com.notrecontinent.webapi.entities.Article;
import com.notrecontinent.webapi.security.jwt.JwtUtils;
import com.notrecontinent.webapi.services.ArticleService;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/momar"})
@CrossOrigin(origins={"*"}, allowedHeaders={"*"})
public class ArticleController {
    @Autowired
    private ArticleService articleService;
    @Autowired
    private JwtUtils jwtUtils;

    @GetMapping(value={"/Article/video/{video}"})
    public String getvideo(@PathVariable(value="video") String videoname) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Chargement de la video d'un article par son contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getvideo(videoname);
    }

    @GetMapping(value={"/Article/audio/{audio}"})
    public String getaudio(@PathVariable(value="audio") String audioname) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Chargement de l'audio d'un article par son contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getaudio(audioname);
    }

    @GetMapping(value={"/Article/images/{id}"})
    public List<String> getAutresimagesbyArticle(@PathVariable(value="id") Long id) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Chargement des images d'un article par son contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getAutresimagesbyArticle(id);
    }

    @GetMapping(value={"/Article/all"})
    public List<Article> getAllArticles() {
        return this.articleService.getAllArticles();
    }

    @GetMapping(value={"/Article/auteur/{id}"})
    public ResponseEntity<List<ArticleAuteur>> getAllByActeurID(@PathVariable(value="id") Long id) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des articles par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getAllByActeurID(id);
    }

    @GetMapping(value={"/Article/auteur/all/{id}/{pageNumber}"})
    public ResponseEntity<ArticlesAuteurDTO> getAllArticlesByActeurID(@PathVariable(value="id") Long id, @PathVariable(value="pageNumber") int pageNumber) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des articles par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getAllArticlesByActeurID(id, pageNumber);
    }

    @GetMapping(value={"/Article/auteur/filtre/{id}/{status}/{pageNumber}"})
    public ResponseEntity<ArticlesAuteurDTO> FiltrerArticlesByActeurIDAndStatus(@PathVariable(value="id") Long id, @PathVariable(value="status") String status, @PathVariable(value="pageNumber") int pageNumber) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des articles filtr\u00e9s par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.FiltrerArticlesByActeurIDAndStatus(id, status, pageNumber);
    }

    @PostMapping(value={"/Article/auteur/rech/{id}/{pageNumber}"})
    public ResponseEntity<ArticlesAuteurDTO> RechercherArticlesByActeurID(@PathVariable(value="id") Long id, @RequestParam(value="rech") String rech, @PathVariable(value="pageNumber") int pageNumber) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des articles recherch\u00e9s par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.RechercherArticlesByActeurID(id, rech, pageNumber);
    }

    @GetMapping(value={"/Article/auteur/status/{id}/{status}"})
    public ResponseEntity<List<Article>> getAllByActeurIDAndStatus(@PathVariable(value="id") Long id, @PathVariable(value="status") String status) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des articles par status par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getAllByActeurIDAndStatus(id, status);
    }

    @GetMapping(value={"/Article/get/{id}"})
    public ResponseEntity<ArticleDto> getArticleByID(@PathVariable(value="id") Long id) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration d'un article par son contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getArticleByID(id);
    }

    @GetMapping(value={"/Article/brouillon/{id}/{pageNumber}"})
    public ResponseEntity<ArticlesBrouillonAuteurDTO> getArticlesBrouillonsByAuteurId(@PathVariable(value="id") Long id, @RequestParam(required=false) String rech, @PathVariable(value="pageNumber") int pageNumber) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des articles brouillon par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getArticlesBrouillonsByAuteurId(id, rech, pageNumber);
    }

    @GetMapping(value={"/Article/rejete/{id}/{pageNumber}"})
    public ResponseEntity<ArticlesRejetesAuteurDTO> getArticlesRejetesByAuteurId(@PathVariable(value="id") Long id, @RequestParam(required=false) String rech, @PathVariable(value="pageNumber") int pageNumber) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des articles rejet\u00e9s par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getArticlesRejetesByAuteurId(id, rech, pageNumber);
    }

    @GetMapping(value={"/Article/valide/{id}/{pageNumber}"})
    public ResponseEntity<ArticlesValidesAuteurDTO> getArticlesValidesByAuteurId(@PathVariable(value="id") Long id, @RequestParam(required=false) String rech, @PathVariable(value="pageNumber") int pageNumber) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des articles valid\u00e9s par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getArticlesValidesByAuteurId(id, rech, pageNumber);
    }

    @GetMapping(value={"/Article/validationencours/{id}/{pageNumber}"})
    public ResponseEntity<ArticlesValidationEnCoursAuteurDTO> getArticlesValidationencoursByAuteurId(@PathVariable(value="id") Long id, @RequestParam(required=false) String rech, @PathVariable(value="pageNumber") int pageNumber) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des articles en cours de validation par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.getArticlesValidationencoursByAuteurId(id, rech, pageNumber);
    }

    @PostMapping(value={"/Article/new"})
    public Article AddArticle(@RequestParam(value="file") MultipartFile file, @RequestParam(value="files") Optional<MultipartFile[]> files, @RequestParam(value="audioVideo") Optional<MultipartFile> audioVideo, @RequestParam(value="article") String article) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Cr\u00e9ation d'un nouvel article par un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.AddArticle(file, files, audioVideo, article);
    }

    @PostMapping(value={"/Article/newvideo"})
    public Article AddVideoArticle(@RequestParam(value="audioVideo") MultipartFile audioVideo, @RequestParam(value="article") String article) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Cr\u00e9ation d'un nouvel article video par un contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.AddVideo(audioVideo, article);
    }

    @PutMapping(value={"/Article/modifier"})
    public Article ModifierArticleWithMedias(@RequestParam(value="file") Optional<MultipartFile> file, @RequestParam(value="files") Optional<MultipartFile[]> files, @RequestParam(value="audioVideo") Optional<MultipartFile> audioVideo, @RequestParam(value="newarticle") String newarticle) throws JsonProcessingException {
        return this.articleService.ModifierArticle(file, files, audioVideo, newarticle);
    }

    @PutMapping(value={"/Article/modify"})
    public Article ModifyArticleWithMedias(@RequestParam(value="file") Optional<MultipartFile> file, @RequestParam(value="files") Optional<String> files, @RequestParam(value="audioVideo") Optional<MultipartFile> audioVideo, @RequestParam(value="newarticle") String newarticle) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Modification d'un article par son contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.ModifyArticle(file, files, audioVideo, newarticle);
    }

    @PutMapping(value={"/Article/update/status/{id}/{status}"})
    public Article UpdateStatus(@PathVariable(value="id") Long id, @PathVariable(value="status") String status) {
        return this.articleService.UpdateStatus(id, status);
    }

    @DeleteMapping(value={"/Article/{id}"})
    public String deleteArticle(@PathVariable(value="id") Long id) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Suppression d'un article par son contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.deleteArticle(id);
    }

    @DeleteMapping(value={"/Article/delete"})
    public String deleteArticles(@Validated @RequestBody List<Long> ids) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Suppression de plusieurs articles par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.articleService.deleteArticles(ids);
    }
}

