/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.LesDTOs.RecommandationAmiDTO;
import com.notrecontinent.webapi.LesDTOs.RecommandationDTO;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.ClicRecommandation;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.Recommandation;
import com.notrecontinent.webapi.mapstruct.CategorieMapper;
import com.notrecontinent.webapi.mapstruct.RecommandationMapper;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.ClicRecommandationRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.MailService;
import com.notrecontinent.webapi.services.SmsService;
import com.notrecontinent.webapi.services.WhatsappService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
public class RecommandationService {
    @Value(value="${parametre.lien.recommandation}")
    private Long param;
    @Autowired
    private RecommandationMapper recommandationMapper;
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private ClicRecommandationRepository clicRecommandationRepository;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private CategorieMapper categorieMapper;
    @Autowired
    private MailService mailService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private WhatsappService whatsappService;
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    public ResponseEntity<RecommandationAmiDTO> getAllRecommandationsByAmiId(Long id, int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        System.out.println(pageRequest);
        Page page = this.recommandationRepository.findAllByAuteuridOrderByEstcliquerAscDateCreationDesc(id, (Pageable)pageRequest);
        System.out.println(page);
        List recommandations = page.getContent();
        System.out.println("nombre total de pages : " + page.getTotalPages());
        RecommandationAmiDTO recommandationAmiDTO = new RecommandationAmiDTO();
        if (!recommandations.isEmpty()) {
            List recommandationAuteurDTOS = this.recommandationMapper.RecommandationsToRecommandateurAuteurDTO(recommandations);
            recommandationAmiDTO.setRecommandations(recommandationAuteurDTOS);
            recommandationAmiDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)recommandationAmiDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)recommandationAmiDTO);
    }

    public ResponseEntity<RecommandationAmiDTO> rechercherRecommandationsByAmiId(Long id, int pageNumber, String recherche) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        System.out.println(pageRequest);
        Page page = this.recommandationRepository.findByAuteuridAndTitrearticleContainingIgnoreCaseOrderByEstcliquerAscDateCreationDesc(id, recherche, (Pageable)pageRequest);
        System.out.println(page);
        List recommandations = page.getContent();
        System.out.println("nombre total de page : " + page.getTotalPages());
        RecommandationAmiDTO recommandationAmiDTO = new RecommandationAmiDTO();
        if (!recommandations.isEmpty()) {
            List recommandationAuteurDTOS = this.recommandationMapper.RecommandationsToRecommandateurAuteurDTO(recommandations);
            recommandationAmiDTO.setRecommandations(recommandationAuteurDTOS);
            recommandationAmiDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)recommandationAmiDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)recommandationAmiDTO);
    }

    public ResponseEntity<RecommandationAmiDTO> getRecommandationsByAmiIdandEstcliquer(Long id, int pageNumber, Boolean estcliquer) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        System.out.println(pageRequest);
        Page page = null;
        page = estcliquer != false ? this.recommandationRepository.findByAuteuridAndEstcliquerAndFraudeOrderByDateClickDesc(id, Boolean.valueOf(true), Boolean.valueOf(false), (Pageable)pageRequest) : this.recommandationRepository.findByAuteuridAndEstcliquerOrderByEstcliquerAscDateCreationDesc(id, estcliquer, (Pageable)pageRequest);
        System.out.println(page);
        List recommandations = page.getContent();
        System.out.println("nombre total de pages : " + page.getTotalPages());
        RecommandationAmiDTO recommandationAmiDTO = new RecommandationAmiDTO();
        if (!recommandations.isEmpty()) {
            List recommandationAuteurDTOS = this.recommandationMapper.RecommandationsToRecommandateurAuteurDTO(recommandations);
            recommandationAmiDTO.setRecommandations(recommandationAuteurDTOS);
            recommandationAmiDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)recommandationAmiDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)recommandationAmiDTO);
    }

    public ResponseEntity<RecommandationAmiDTO> getRecommandationsFraudesByAmiId(Long id, int pageNumber) throws JsonProcessingException {
        PageRequest pageRequest = PageRequest.of((int)pageNumber, (int)20);
        System.out.println(pageRequest);
        Page page = this.recommandationRepository.findByAuteuridAndEstcliquerAndFraudeOrderByDateClickDesc(id, Boolean.valueOf(true), Boolean.valueOf(true), (Pageable)pageRequest);
        System.out.println(page);
        List recommandations = page.getContent();
        System.out.println("nombre total de pages : " + page.getTotalPages());
        RecommandationAmiDTO recommandationAmiDTO = new RecommandationAmiDTO();
        if (!recommandations.isEmpty()) {
            List recommandationAuteurDTOS = this.recommandationMapper.RecommandationsToRecommandateurAuteurDTO(recommandations);
            recommandationAmiDTO.setRecommandations(recommandationAuteurDTOS);
            recommandationAmiDTO.setTotalPages(page.getTotalPages());
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)recommandationAmiDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)recommandationAmiDTO);
    }

    @Transactional
    public Recommandation AddRecommandation(Recommandation recommandation) {
        Recommandation recommandation1 = this.recommandationRepository.findByParametre(this.param);
        if (recommandation1 != null) {
            Recommandation recommandation2 = this.recommandationRepository.findFirstByOrderByIdDesc();
            this.param = recommandation2.getParametre() + 1L;
        }
        recommandation.setParametre(this.param);
        recommandation.setEstcliquer(Boolean.valueOf(false));
        recommandation.setCompte("toplayene95@gmail.com");
        recommandation.setAuteurid(Long.valueOf(11L));
        String lienrecommandation = "http://localhost:4300/";
        lienrecommandation = lienrecommandation + recommandation.getLienarticle().split("notrecontinent.com/")[1];
        lienrecommandation = lienrecommandation + recommandation.getParametre();
        recommandation.setLienrecommandation(lienrecommandation);
        Recommandation recommandation2 = (Recommandation)this.recommandationRepository.save((Object)recommandation);
        this.param = this.param + 1L;
        return recommandation2;
    }

    @Transactional
    public String UpdateStatusRecommandation(Long parametre) {
        Recommandation recommandation = this.recommandationRepository.findByParametre(parametre);
        if (recommandation != null) {
            if (!recommandation.getEstcliquer().booleanValue()) {
                recommandation.setEstcliquer(Boolean.valueOf(true));
                this.recommandationRepository.save((Object)recommandation);
            }
            return "lu";
        }
        return "non lu";
    }

    @Transactional
    public String SaveClicRecommandation(List<RecommandationDTO> recommandationDTOList) {
        block9: {
            try {
                ClicRecommandation clicRecommandation;
                if (recommandationDTOList.isEmpty()) break block9;
                LinkedHashSet<RecommandationDTO> recommandationDTOSansDoublons = new LinkedHashSet<RecommandationDTO>(recommandationDTOList);
                recommandationDTOList = new ArrayList<RecommandationDTO>(recommandationDTOSansDoublons);
                List clicRecommandationListAcomparer = this.clicRecommandationRepository.findAll();
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ArrayList<ClicRecommandation> clicRecommandations = new ArrayList<ClicRecommandation>();
                List recommandations = this.recommandationRepository.findByEstcliquer(Boolean.valueOf(false));
                if (!clicRecommandationListAcomparer.isEmpty()) {
                    for (RecommandationDTO r : recommandationDTOList) {
                        if (!clicRecommandationListAcomparer.stream().noneMatch(c -> c.getLienrecommandation().equals(r.getLienrecommandation()))) continue;
                        clicRecommandation = new ClicRecommandation();
                        clicRecommandation.setLienrecommandation(r.getLienrecommandation());
                        clicRecommandation.setParametre(r.getParametre());
                        clicRecommandation.setDateClick(sdf.parse(r.getDateClick()));
                        clicRecommandation.setEsttraiter(false);
                        clicRecommandation.setFraude(null);
                        clicRecommandations.add(clicRecommandation);
                    }
                } else {
                    for (RecommandationDTO r : recommandationDTOList) {
                        clicRecommandation = new ClicRecommandation();
                        clicRecommandation.setLienrecommandation(r.getLienrecommandation());
                        clicRecommandation.setParametre(r.getParametre());
                        clicRecommandation.setDateClick(sdf.parse(r.getDateClick()));
                        clicRecommandation.setEsttraiter(false);
                        clicRecommandation.setFraude(null);
                        clicRecommandations.add(clicRecommandation);
                    }
                }
                if (!recommandations.isEmpty()) {
                    for (RecommandationDTO r : recommandations) {
                        for (ClicRecommandation c2 : clicRecommandations) {
                            if (!r.getLienrecommandation().equals(c2.getLienrecommandation())) continue;
                            c2.setAmiid(r.getAuteurid());
                        }
                    }
                }
                this.clicRecommandationRepository.saveAll(clicRecommandations);
            }
            catch (Exception e) {
                System.out.println("----------------------------------------------------");
                System.out.println("Message du bug");
                System.out.println(e.getMessage());
                System.out.println("----------------------------------------------------");
                this.bugsCronService.SaveBugCron("Cron de stockage des clics de recommandation", e.getMessage());
            }
        }
        return "OK clics saved successfully";
    }

    @Transactional
    public void UpdateRecommandationStatus() {
        try {
            List clicRecommandations = this.clicRecommandationRepository.findByEsttraiterOrderByDateClickAsc(Boolean.valueOf(false));
            if (!clicRecommandations.isEmpty()) {
                LinkedHashSet<Long> clicamiids = new LinkedHashSet<Long>();
                for (Object r : clicRecommandations) {
                    clicamiids.add(r.getAmiid());
                }
                ArrayList clicsParAmi = new ArrayList();
                for (Long l : clicamiids) {
                    List list = clicRecommandations.stream().filter(c -> Objects.equals(c.getAmiid(), id)).collect(Collectors.toList());
                    if (list.isEmpty()) continue;
                    clicsParAmi.add(list);
                }
                for (List list : clicsParAmi) {
                    list.sort(Comparator.comparing(ClicRecommandation::getDateClick));
                }
                for (List list : clicsParAmi) {
                    ClicRecommandation clicRecommandation = (ClicRecommandation)list.get(0);
                    ClicRecommandation clicRecommandation2 = this.clicRecommandationRepository.findFirstByEsttraiterAndAmiidOrderByDateClickDesc(Boolean.valueOf(true), clicRecommandation.getAmiid());
                    if (clicRecommandation2 == null) {
                        ((ClicRecommandation)list.get(0)).setFraude(Boolean.valueOf(false));
                    } else {
                        ((ClicRecommandation)list.get(0)).setFraude(Boolean.valueOf((clicRecommandation.getDateClick().getTime() - clicRecommandation2.getDateClick().getTime()) / 60000L < 2L));
                    }
                    ((ClicRecommandation)list.get(0)).setEsttraiter(true);
                    for (int i = 0; i < list.size(); ++i) {
                        if (i + 1 >= list.size()) continue;
                        ClicRecommandation clic1 = (ClicRecommandation)list.get(i);
                        ClicRecommandation clic2 = (ClicRecommandation)list.get(i + 1);
                        long time1 = clic1.getDateClick().getTime();
                        long time2 = clic2.getDateClick().getTime();
                        long diffInMinutes = (time2 - time1) / 60000L;
                        ((ClicRecommandation)list.get(i + 1)).setFraude(Boolean.valueOf(diffInMinutes < 2L));
                        ((ClicRecommandation)list.get(i + 1)).setEsttraiter(true);
                    }
                }
                ArrayList clicRecommandationListFinal = new ArrayList();
                for (List list : clicsParAmi) {
                    clicRecommandationListFinal.addAll(list);
                }
                this.clicRecommandationRepository.saveAll(clicRecommandationListFinal);
                List list = this.recommandationRepository.findByEstcliquer(Boolean.valueOf(false));
                if (!list.isEmpty()) {
                    System.out.println("recommandations size : " + list.size());
                    block8: for (Recommandation r : list) {
                        for (ClicRecommandation c2 : clicRecommandationListFinal) {
                            if (!r.getLienrecommandation().equals(c2.getLienrecommandation())) continue;
                            r.setEstcliquer(Boolean.valueOf(true));
                            r.setDateClick(c2.getDateClick());
                            r.setFraude(c2.getFraude());
                            if (!r.getFraude().booleanValue()) {
                                Auteur ami = (Auteur)this.auteurRepository.findById((Object)r.getAuteurid()).get();
                                System.out.println(ami);
                                if (ami.getMonetisation() != null && ami.getMonetisation().equals("Oui")) {
                                    LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
                                    Date currentdate = Date.from(now.atZone(ZoneId.of("GMT")).toInstant());
                                    SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                                    String mois = dateFormat.format(currentdate);
                                    PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, r.getAuteurid());
                                    System.out.println("d\u00e9but affectation points");
                                    if (pointsAmi == null) {
                                        PointsAmi p = new PointsAmi();
                                        p.setAmiId(r.getAuteurid());
                                        p.setMois(mois);
                                        p.setNbArticlesLus(Long.valueOf(1L));
                                        p.setNbPointsArticlesLus(Long.valueOf(2L));
                                        p.setNbPointsMois(Long.valueOf(2L));
                                        p.setNbRecommandations(Long.valueOf(0L));
                                        p.setNbPointsRecommandations(Long.valueOf(0L));
                                        p.setNbMissions(Long.valueOf(0L));
                                        p.setNbPointsMissions(Long.valueOf(0L));
                                        ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 2L));
                                        this.pointsAmiRepository.save((Object)p);
                                    } else {
                                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsMois() + 2L));
                                        pointsAmi.setNbPointsArticlesLus(Long.valueOf(pointsAmi.getNbPointsArticlesLus() + 2L));
                                        pointsAmi.setNbArticlesLus(Long.valueOf(pointsAmi.getNbArticlesLus() + 1L));
                                        ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 2L));
                                        this.pointsAmiRepository.save((Object)pointsAmi);
                                    }
                                    System.out.println("fin affectation points & save ami");
                                    this.auteurRepository.save((Object)ami);
                                }
                            }
                            c2.setEsttraiter(true);
                            continue block8;
                        }
                    }
                    this.recommandationRepository.saveAll((Iterable)list);
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de MAJ des points pour les clics de recommandation", e.getMessage());
        }
    }

    @Transactional
    public void UpdateAgainRecommandationStatus() {
        this.UpdateRecommandationStatus();
    }

    @Transactional
    public void UpdateAgain2RecommandationStatus() {
        this.UpdateRecommandationStatus();
    }

    @Transactional
    public void mettreAjourDatesalertesfraudes() {
        List recommandations = this.recommandationRepository.findByFraude(Boolean.valueOf(true));
    }

    @Transactional
    public void EnvoyerAlerteFraudeClicRecommandations() {
        List recommandationsAlerteaenvoyer = this.recommandationRepository.findByEstcliquerAndFraudeOrderByDateClickAsc(Boolean.valueOf(true), Boolean.valueOf(true));
        if (!recommandationsAlerteaenvoyer.isEmpty()) {
            ArrayList<Object> recommandations = new ArrayList<Object>();
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
            String todayString = sdf.format(new Date());
            for (Object r2 : recommandationsAlerteaenvoyer) {
                if (!sdf.format(r2.getDateClick()).equals(todayString)) continue;
                recommandations.add(r2);
            }
            if (!recommandations.isEmpty()) {
                List list;
                LinkedHashSet<Long> recomamiids = new LinkedHashSet<Long>();
                for (Object r3 : recommandations) {
                    recomamiids.add(r3.getAuteurid());
                }
                ArrayList recommandationsParAmi = new ArrayList();
                for (Long l : recomamiids) {
                    recommandationsParAmi.add(recommandations.stream().filter(r -> Objects.equals(r.getAuteurid(), id)).collect(Collectors.toList()));
                }
                for (List list2 : recommandationsParAmi) {
                    list2.sort(Comparator.comparing(Recommandation::getDateClick));
                }
                LinkedHashSet<Long> idsamis = new LinkedHashSet<Long>();
                block4: for (List list3 : recommandationsParAmi) {
                    for (int i = 0; i < list3.size(); ++i) {
                        if (i + 2 >= list3.size() || !((Recommandation)list3.get(i)).getFraude().booleanValue() || !((Recommandation)list3.get(i + 1)).getFraude().booleanValue() || !((Recommandation)list3.get(i + 2)).getFraude().booleanValue()) continue;
                        idsamis.add(((Recommandation)list3.get(i)).getAuteurid());
                        continue block4;
                    }
                }
                if (!idsamis.isEmpty() && !(list = this.auteurRepository.findByIdIn(new ArrayList(idsamis))).isEmpty()) {
                    List ids;
                    ArrayList arrayList = new ArrayList();
                    ArrayList emails = new ArrayList();
                    ArrayList numwhatsapps = new ArrayList();
                    for (Auteur ami : list) {
                        ArrayList<String> list4;
                        if (ami.getMessagesWhatsapp().booleanValue() && ami.getNumwhatsapp() != null && !Objects.equals(ami.getNumwhatsapp(), "")) {
                            list4 = new ArrayList<String>();
                            list4.add(String.valueOf(ami.getId()));
                            list4.add(ami.getNumwhatsapp());
                            list4.add(ami.getFirst_name());
                            numwhatsapps.add(list4);
                            continue;
                        }
                        if (ami.getMessagesEmail().booleanValue() && ami.getCreerpar().equals("email")) {
                            list4 = new ArrayList();
                            list4.add(String.valueOf(ami.getId()));
                            list4.add(ami.getUsername());
                            list4.add(ami.getFirst_name());
                            emails.add(list4);
                            continue;
                        }
                        if (ami.getMessagesEmail().booleanValue() && ami.getCreerpar().equals("t\u00e9l\u00e9phone") && ami.getEmail() != null && !Objects.equals(ami.getEmail(), "") && !ami.getEmail().endsWith("@notrecontinent.com")) {
                            list4 = new ArrayList();
                            list4.add(String.valueOf(ami.getId()));
                            list4.add(ami.getEmail());
                            list4.add(ami.getFirst_name());
                            emails.add(list4);
                            continue;
                        }
                        if (!ami.getCreerpar().equals("t\u00e9l\u00e9phone") || !ami.getPays().equals("S\u00e9n\u00e9gal") || !ami.getUsername().startsWith("221")) continue;
                        list4 = new ArrayList();
                        list4.add(String.valueOf(ami.getId()));
                        list4.add(ami.getUsername());
                        list4.add(ami.getFirst_name());
                        arrayList.add(list4);
                    }
                    LinkedHashSet longLinkedHashSet = new LinkedHashSet();
                    if (!numwhatsapps.isEmpty() && !(ids = this.whatsappService.envoyerAlertesfraudesclicrecommandations(numwhatsapps)).isEmpty()) {
                        longLinkedHashSet.addAll(ids);
                    }
                    if (!arrayList.isEmpty() && !(ids = this.smsService.Envoyeralertesfraudesclicrecommandations(arrayList)).isEmpty()) {
                        longLinkedHashSet.addAll(ids);
                    }
                    if (!emails.isEmpty() && !(ids = this.mailService.envoyerAlertesClics(emails)).isEmpty()) {
                        longLinkedHashSet.addAll(ids);
                    }
                    if (!longLinkedHashSet.isEmpty()) {
                        ArrayList longList = new ArrayList(longLinkedHashSet);
                        for (Recommandation r4 : recommandationsAlerteaenvoyer) {
                            if (!longList.contains(r4.getAuteurid())) continue;
                            r4.setAlertefraudeenvoyer(Boolean.valueOf(true));
                        }
                        this.recommandationRepository.saveAll((Iterable)recommandationsAlerteaenvoyer);
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    for (Auteur ami : list) {
                        List<String> datesalertes = new ArrayList<String>();
                        if (!ami.getDatesfraudes().isEmpty()) {
                            datesalertes = ami.getDatesfraudes();
                        }
                        datesalertes.add(simpleDateFormat.format(new Date()));
                    }
                    this.auteurRepository.saveAll((Iterable)list);
                }
            }
        }
    }
}

