/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.LesDTOs.NotificationSmsStatus;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.RecommandationAunAmi;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationAunAmiRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.MailService;
import com.notrecontinent.webapi.services.SmsService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecommandationAunAmiService {
    @Autowired
    private RecommandationAunAmiRepository recommandationAunAmiRepository;
    @Autowired
    private SmsService smsService;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private MailService mailService;

    @Transactional
    public void VerifyNumSN1() {
        List recommandationAunAmiList = this.recommandationAunAmiRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!recommandationAunAmiList.isEmpty()) {
            for (RecommandationAunAmi r : recommandationAunAmiList) {
                if (!r.getAenvoyerpar().equals("sms") || r.getTeldestinataire().startsWith("221") && r.getTeldestinataire().length() == 12) continue;
                r.setEstenvoyer(null);
            }
            this.recommandationAunAmiRepository.saveAll((Iterable)recommandationAunAmiList);
        }
    }

    @Transactional
    public void VerifyNumSN2() {
        List recommandationAunAmiList = this.recommandationAunAmiRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!recommandationAunAmiList.isEmpty()) {
            for (RecommandationAunAmi r : recommandationAunAmiList) {
                if (!r.getAenvoyerpar().equals("sms") || r.getTeldestinataire().startsWith("221") && r.getTeldestinataire().length() == 12) continue;
                r.setEstenvoyer(null);
            }
            this.recommandationAunAmiRepository.saveAll((Iterable)recommandationAunAmiList);
        }
    }

    @Transactional
    public void EnvoyerSmsRecommandationAunAmi1() {
        try {
            List recommandationAunAmiList1 = this.recommandationAunAmiRepository.findByEstenvoyer(Boolean.valueOf(false));
            if (!recommandationAunAmiList1.isEmpty()) {
                ArrayList<RecommandationAunAmi> recommandationAunAmiList = new ArrayList<RecommandationAunAmi>();
                Date currentdate1 = new Date();
                for (RecommandationAunAmi recommandationAunAmi : recommandationAunAmiList1) {
                    if ((currentdate1.getTime() - recommandationAunAmi.getDateCreation().getTime()) / 3600000L < 12L) continue;
                    recommandationAunAmiList.add(recommandationAunAmi);
                }
                if (!recommandationAunAmiList.isEmpty()) {
                    for (RecommandationAunAmi r : recommandationAunAmiList) {
                        try {
                            if (r.getAenvoyerpar().equals("sms")) {
                                String expediteurname = "";
                                int nbchars = r.getNomExpediteur().length() + r.getPrenomExpediteur().length();
                                expediteurname = nbchars > 17 ? r.getPrenomExpediteur() : r.getPrenomExpediteur() + " " + r.getNomExpediteur();
                                NotificationSmsStatus notificationSmsStatus = this.smsService.EnvoyerSmsRecommandationAunAmi(r.getNumeroExpediteur(), expediteurname, r.getTeldestinataire(), r.getPrenomdestinataire() + " " + r.getNomdestinataire(), r.getMessage());
                                if (!notificationSmsStatus.getMessage().equals("success") || !notificationSmsStatus.getCode().equals(200L)) continue;
                                r.setEstenvoyer(Boolean.valueOf(true));
                                r.setDateenvoi(new Date());
                                continue;
                            }
                            if (!r.getAenvoyerpar().equals("email")) continue;
                            this.mailService.EnvoyerEmailRecommandationAunAmi(r.getNumeroExpediteur(), r.getPrenomExpediteur() + " " + r.getNomExpediteur(), r.getPrenomdestinataire(), r.getTeldestinataire(), r.getMessage());
                            r.setEstenvoyer(Boolean.valueOf(true));
                            r.setDateenvoi(new Date());
                        }
                        catch (Exception e) {
                            System.out.println("----------------------------------------------------");
                            System.out.println("Message du bug");
                            System.out.println(e.getMessage());
                            System.out.println("----------------------------------------------------");
                            this.bugsCronService.SaveBugCron("Cron d'envoi des Recommandations \u00e0 un ami \u00e0 " + r.getTeldestinataire(), e.getMessage());
                        }
                    }
                    this.recommandationAunAmiRepository.saveAll(recommandationAunAmiList);
                    for (RecommandationAunAmi r : recommandationAunAmiList) {
                        if (!r.getEstenvoyer().booleanValue()) continue;
                        LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
                        Date currentdate = Date.from(now.atZone(ZoneId.of("GMT")).toInstant());
                        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                        String mois = dateFormat.format(currentdate);
                        Auteur ami = (Auteur)this.auteurRepository.findById((Object)r.getAmiID()).get();
                        if (ami.getMonetisation() == null || !ami.getMonetisation().equals("Oui")) continue;
                        PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, r.getAmiID());
                        if (pointsAmi == null) {
                            PointsAmi p = new PointsAmi();
                            p.setAmiId(r.getAmiID());
                            p.setMois(mois);
                            p.setNbArticlesLus(Long.valueOf(0L));
                            p.setNbPointsArticlesLus(Long.valueOf(0L));
                            p.setNbPointsMois(Long.valueOf(5L));
                            p.setNbArticlesLus(Long.valueOf(0L));
                            p.setNbRecommandations(Long.valueOf(1L));
                            p.setNbPointsRecommandations(Long.valueOf(5L));
                            p.setNbMissions(Long.valueOf(0L));
                            p.setNbPointsMissions(Long.valueOf(0L));
                            ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 5L));
                            this.auteurRepository.save((Object)ami);
                            this.pointsAmiRepository.save((Object)p);
                            continue;
                        }
                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsMois() + 5L));
                        pointsAmi.setNbRecommandations(Long.valueOf(pointsAmi.getNbRecommandations() + 1L));
                        pointsAmi.setNbPointsRecommandations(Long.valueOf(pointsAmi.getNbPointsRecommandations() + 5L));
                        ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 5L));
                        this.auteurRepository.save((Object)ami);
                        this.pointsAmiRepository.save((Object)pointsAmi);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron d'envoi des Recommandations \u00e0 un ami", e.getMessage());
        }
    }

    @Transactional
    public void EnvoyerSmsRecommandationAunAmi2() {
        try {
            List recommandationAunAmiList1 = this.recommandationAunAmiRepository.findByEstenvoyer(Boolean.valueOf(false));
            if (!recommandationAunAmiList1.isEmpty()) {
                ArrayList<RecommandationAunAmi> recommandationAunAmiList = new ArrayList<RecommandationAunAmi>();
                Date currentdate1 = new Date();
                for (RecommandationAunAmi recommandationAunAmi : recommandationAunAmiList1) {
                    if ((currentdate1.getTime() - recommandationAunAmi.getDateCreation().getTime()) / 3600000L < 12L) continue;
                    recommandationAunAmiList.add(recommandationAunAmi);
                }
                if (!recommandationAunAmiList.isEmpty()) {
                    for (RecommandationAunAmi r : recommandationAunAmiList) {
                        try {
                            if (r.getAenvoyerpar().equals("sms")) {
                                String expediteurname = "";
                                int nbchars = r.getNomExpediteur().length() + r.getPrenomExpediteur().length();
                                expediteurname = nbchars > 17 ? r.getPrenomExpediteur() : r.getPrenomExpediteur() + " " + r.getNomExpediteur();
                                NotificationSmsStatus notificationSmsStatus = this.smsService.EnvoyerSmsRecommandationAunAmi(r.getNumeroExpediteur(), expediteurname, r.getTeldestinataire(), r.getPrenomdestinataire() + " " + r.getNomdestinataire(), r.getMessage());
                                if (!notificationSmsStatus.getMessage().equals("success") || !notificationSmsStatus.getCode().equals(200L)) continue;
                                r.setEstenvoyer(Boolean.valueOf(true));
                                r.setDateenvoi(new Date());
                                continue;
                            }
                            if (!r.getAenvoyerpar().equals("email")) continue;
                            this.mailService.EnvoyerEmailRecommandationAunAmi(r.getNumeroExpediteur(), r.getPrenomExpediteur() + " " + r.getNomExpediteur(), r.getPrenomdestinataire(), r.getTeldestinataire(), r.getMessage());
                            r.setEstenvoyer(Boolean.valueOf(true));
                            r.setDateenvoi(new Date());
                        }
                        catch (Exception e) {
                            System.out.println("----------------------------------------------------");
                            System.out.println("Message du bug");
                            System.out.println(e.getMessage());
                            System.out.println("----------------------------------------------------");
                            this.bugsCronService.SaveBugCron("Cron d'envoi des Recommandations \u00e0 un ami \u00e0 " + r.getTeldestinataire(), e.getMessage());
                        }
                    }
                    this.recommandationAunAmiRepository.saveAll(recommandationAunAmiList);
                    for (RecommandationAunAmi r : recommandationAunAmiList) {
                        if (!r.getEstenvoyer().booleanValue()) continue;
                        LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
                        Date currentdate = Date.from(now.atZone(ZoneId.of("GMT")).toInstant());
                        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                        String mois = dateFormat.format(currentdate);
                        Auteur ami = (Auteur)this.auteurRepository.findById((Object)r.getAmiID()).get();
                        if (ami.getMonetisation() == null || !ami.getMonetisation().equals("Oui")) continue;
                        PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, r.getAmiID());
                        if (pointsAmi == null) {
                            PointsAmi p = new PointsAmi();
                            p.setAmiId(r.getAmiID());
                            p.setMois(mois);
                            p.setNbArticlesLus(Long.valueOf(0L));
                            p.setNbPointsArticlesLus(Long.valueOf(0L));
                            p.setNbPointsMois(Long.valueOf(5L));
                            p.setNbArticlesLus(Long.valueOf(0L));
                            p.setNbRecommandations(Long.valueOf(1L));
                            p.setNbPointsRecommandations(Long.valueOf(5L));
                            p.setNbMissions(Long.valueOf(0L));
                            p.setNbPointsMissions(Long.valueOf(0L));
                            ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 5L));
                            this.auteurRepository.save((Object)ami);
                            this.pointsAmiRepository.save((Object)p);
                            continue;
                        }
                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsMois() + 5L));
                        pointsAmi.setNbRecommandations(Long.valueOf(pointsAmi.getNbRecommandations() + 1L));
                        pointsAmi.setNbPointsRecommandations(Long.valueOf(pointsAmi.getNbPointsRecommandations() + 5L));
                        ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 5L));
                        this.auteurRepository.save((Object)ami);
                        this.pointsAmiRepository.save((Object)pointsAmi);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron d'envoi des Recommandations \u00e0 un ami", e.getMessage());
        }
    }

    @Transactional
    public void EnvoyerSmsRecommandationAunAmi() {
        try {
            List recommandationAunAmiList = this.recommandationAunAmiRepository.findByEstenvoyer(Boolean.valueOf(false));
            if (!recommandationAunAmiList.isEmpty()) {
                ArrayList<RecommandationAunAmi> recommandationAunAmiList2 = new ArrayList<RecommandationAunAmi>();
                Date currentdatenow = new Date();
                for (RecommandationAunAmi r : recommandationAunAmiList) {
                    long diffinminutes = (currentdatenow.getTime() - r.getDateCreation().getTime()) / 60000L;
                    if (diffinminutes <= 5L) continue;
                    recommandationAunAmiList2.add(r);
                }
                if (!recommandationAunAmiList2.isEmpty()) {
                    for (RecommandationAunAmi r : recommandationAunAmiList2) {
                        if (r.getAenvoyerpar().equals("sms")) {
                            String expediteurname = "";
                            int nbchars = r.getNomExpediteur().length() + r.getPrenomExpediteur().length();
                            expediteurname = nbchars > 17 ? r.getPrenomExpediteur() : r.getPrenomExpediteur() + " " + r.getNomExpediteur();
                            NotificationSmsStatus notificationSmsStatus = this.smsService.EnvoyerSmsRecommandationAunAmi(r.getNumeroExpediteur(), expediteurname, r.getTeldestinataire(), r.getPrenomdestinataire() + " " + r.getNomdestinataire(), r.getMessage());
                            if (!notificationSmsStatus.getMessage().equals("success") || !notificationSmsStatus.getCode().equals(200L)) continue;
                            r.setEstenvoyer(Boolean.valueOf(true));
                            r.setDateenvoi(new Date());
                            continue;
                        }
                        if (!r.getAenvoyerpar().equals("email")) continue;
                        this.mailService.EnvoyerEmailRecommandationAunAmi(r.getNumeroExpediteur(), r.getPrenomExpediteur() + " " + r.getNomExpediteur(), r.getPrenomdestinataire(), r.getTeldestinataire(), r.getMessage());
                        r.setEstenvoyer(Boolean.valueOf(true));
                        r.setDateenvoi(new Date());
                    }
                    this.recommandationAunAmiRepository.saveAll(recommandationAunAmiList2);
                    for (RecommandationAunAmi r : recommandationAunAmiList2) {
                        LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
                        Date currentdate = Date.from(now.atZone(ZoneId.of("GMT")).toInstant());
                        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
                        String mois = dateFormat.format(currentdate);
                        PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, r.getAmiID());
                        Auteur ami = (Auteur)this.auteurRepository.findById((Object)r.getAmiID()).get();
                        if (pointsAmi == null) {
                            PointsAmi p = new PointsAmi();
                            p.setAmiId(r.getAmiID());
                            p.setMois(mois);
                            p.setNbArticlesLus(Long.valueOf(0L));
                            p.setNbPointsArticlesLus(Long.valueOf(0L));
                            p.setNbPointsMois(Long.valueOf(5L));
                            p.setNbArticlesLus(Long.valueOf(0L));
                            p.setNbRecommandations(Long.valueOf(1L));
                            p.setNbPointsRecommandations(Long.valueOf(5L));
                            p.setNbMissions(Long.valueOf(0L));
                            p.setNbPointsMissions(Long.valueOf(0L));
                            ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 5L));
                            this.auteurRepository.save((Object)ami);
                            this.pointsAmiRepository.save((Object)p);
                            continue;
                        }
                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsMois() + 5L));
                        pointsAmi.setNbRecommandations(Long.valueOf(pointsAmi.getNbRecommandations() + 1L));
                        pointsAmi.setNbPointsRecommandations(Long.valueOf(pointsAmi.getNbPointsRecommandations() + 5L));
                        ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 5L));
                        this.auteurRepository.save((Object)ami);
                        this.pointsAmiRepository.save((Object)pointsAmi);
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron d'envoi des Recommandations \u00e0 un ami par sms", e.getMessage());
        }
    }

    public List<RecommandationAunAmi> getRecommandationsAunAmiBidAmiID(Long id) {
        return this.recommandationAunAmiRepository.findByAmiID(id);
    }
}

