/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.config.UrlConfig;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Service;

@Service
public class PhotoService {
    private final Path root = UrlConfig.root;
    private final Path root82 = UrlConfig.root82;
    private final Path rootIdentites = UrlConfig.rootIdentites;
    private final String imagesPath = "/home/speak2024/dev.speakyfree.com/Uploads";
    private final String imagesPath82 = "/home/speak2024/dev.speakyfree.com/Uploads82";

    public void resizeImage(String inputImagePath, String outputImagePath) {
        try {
            File fileToDelete = new File(outputImagePath);
            if (fileToDelete.exists()) {
                fileToDelete.delete();
            }
            Thumbnails.of((String[])new String[]{inputImagePath}).size(82, 82).outputQuality(1.0).outputFormat("jpeg").toFile(outputImagePath);
            System.out.println("image resized to 82 x 82");
        }
        catch (IOException e) {
            System.out.println("IMAGE NOT RESIZED TO 82 x 82");
        }
    }

    public String SaveFiles(List<String> files, Long auteurID) {
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String dateString = format.format(new Date());
        String autresfilenames = "";
        for (int i = 0; i < files.size(); ++i) {
            String base64String = files.get(i).split(",")[1];
            byte[] fileContent = DatatypeConverter.parseBase64Binary((String)base64String);
            String extension = files.get(i).split(";")[0].split("/")[1];
            String filename = "article-" + i + "-" + auteurID + "-" + dateString + "." + extension;
            Path filePath = Paths.get("/home/speak2024/dev.speakyfree.com/Uploads", filename);
            try {
                Files.write(filePath, fileContent, new OpenOption[0]);
                this.resizeImage("/home/speak2024/dev.speakyfree.com/Uploads/" + filename, "/home/speak2024/dev.speakyfree.com/Uploads82/" + filename);
                autresfilenames = autresfilenames + filename + "/";
                System.out.println("File created successfully at " + filePath);
                continue;
            }
            catch (IOException e) {
                System.out.println("An error occurred while creating the file.");
            }
        }
        return autresfilenames;
    }

    public List<String> getAllPhotos(String[] photosBD) throws IOException {
        ArrayList<String> photos = new ArrayList<String>();
        for (int i = 0; i < photosBD.length; ++i) {
            String filename = photosBD[i];
            try {
                Path file = this.root.resolve(filename);
                UrlResource resource = new UrlResource(file.toUri());
                if (!resource.exists() && !resource.isReadable()) {
                    throw new RuntimeException("Could not read the file!");
                }
                String extension = filename.split("\\.")[1];
                photos.add("data:image/" + extension + ";base64," + DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(file)));
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Error: " + e.getMessage());
            }
        }
        return photos;
    }

    public String getVideo(String filename) throws IOException {
        try {
            Path file = this.root.resolve(filename);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                String extension = filename.split("\\.")[1];
                return "data:video/mp4;base64," + DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(file));
            }
            throw new RuntimeException("Could not read the file!");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error: " + e.getMessage());
        }
    }

    public String getAudio(String filename) throws IOException {
        try {
            Path file = this.root.resolve(filename);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                String extension = filename.split("\\.")[1];
                return "data:audio/" + extension + ";base64," + DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(file));
            }
            throw new RuntimeException("Could not read the file!");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error: " + e.getMessage());
        }
    }

    public String getPhoto(String filename) throws IOException {
        try {
            Path file = this.root.resolve(filename);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                String extension = filename.split("\\.")[1];
                return "data:image/" + extension + ";base64," + DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(file));
            }
            throw new RuntimeException("Could not read the file!");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error: " + e.getMessage());
        }
    }

    public String getPhoto82(String filename) throws IOException {
        try {
            Path file = this.root82.resolve(filename);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                String extension = filename.split("\\.")[1];
                return "data:image/" + extension + ";base64," + DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(file));
            }
            throw new RuntimeException("Could not read the file!");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error: " + e.getMessage());
        }
    }

    public String getPhotoIdentite(String filename) throws IOException {
        try {
            Path file = this.rootIdentites.resolve(filename);
            UrlResource resource = new UrlResource(file.toUri());
            if (resource.exists() || resource.isReadable()) {
                String extension = filename.split("\\.")[1];
                return "data:image/" + extension + ";base64," + DatatypeConverter.printBase64Binary((byte[])Files.readAllBytes(file));
            }
            throw new RuntimeException("Could not read the file!");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Error: " + e.getMessage());
        }
    }

    public void deletePhotoIdentite(String filename) {
        try {
            Files.deleteIfExists(this.rootIdentites.resolve(filename));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not delete the file . Error: " + e.getMessage());
        }
    }

    public List<byte[]> getPhotos(String[] photosBD) throws IOException {
        ArrayList<byte[]> photos = new ArrayList<byte[]>();
        for (int i = 0; i < photosBD.length; ++i) {
            String filename = photosBD[i];
            try {
                Path file = this.root.resolve(filename);
                UrlResource resource = new UrlResource(file.toUri());
                if (!resource.exists() && !resource.isReadable()) {
                    throw new RuntimeException("Could not read the file!");
                }
                String extension = filename.split("\\.")[1];
                photos.add(Files.readAllBytes(file));
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Error: " + e.getMessage());
            }
        }
        return photos;
    }

    public void deleteImage(String img) {
        try {
            Files.deleteIfExists(this.root.resolve(img));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not delete the file . Error: " + e.getMessage());
        }
    }

    public void deleteImages(String[] images) {
        for (int i = 0; i < images.length; ++i) {
            String filename = images[i];
            try {
                Files.deleteIfExists(this.root.resolve(filename));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not delete the file . Error: " + e.getMessage());
            }
        }
    }

    public void deleteAllPhotos(String[] photosBD) {
        for (int i = 0; i < photosBD.length; ++i) {
            String filename = photosBD[i];
            try {
                Files.deleteIfExists(this.root.resolve(filename));
                new File("/home/speak2024/dev.speakyfree.com/Uploads82/" + filename).delete();
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not delete the file . Error: " + e.getMessage());
            }
        }
    }
}

