/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.notrecontinent.webapi.LesDTOs.ArticlesAdminDto;
import com.notrecontinent.webapi.LesDTOs.AuteurAdminDto;
import com.notrecontinent.webapi.LesDTOs.AuteurAdminDtoWithPages;
import com.notrecontinent.webapi.LesDTOs.AuteurPwdDTOWithPages;
import com.notrecontinent.webapi.LesDTOs.AuteurRequeteDTO;
import com.notrecontinent.webapi.LesDTOs.BugDTO;
import com.notrecontinent.webapi.LesDTOs.ConnexionAdminDTO;
import com.notrecontinent.webapi.LesDTOs.MessageDTO;
import com.notrecontinent.webapi.LesDTOs.RecommandationAdminDTO;
import com.notrecontinent.webapi.LesDTOs.RequeteDTO;
import com.notrecontinent.webapi.LesDTOs.StatistiqueArticleDTO;
import com.notrecontinent.webapi.dto.DashbordStats;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Message;
import com.notrecontinent.webapi.entities.PaiementAdmin;
import com.notrecontinent.webapi.entities.Transaction;
import com.notrecontinent.webapi.response.UserInfoResponse;
import com.notrecontinent.webapi.services.AdminService;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/speaky"})
@CrossOrigin(value={"*"})
public class AdminController {
    @Autowired
    private AdminService adminService;

    @PostMapping(value={"/Admin/connexion"})
    public ResponseEntity<ConnexionAdminDTO> getAllConnexion(@RequestParam(defaultValue="0") String pageNumber) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de toutes les connexions par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAllConnexion(Integer.parseInt(pageNumber));
    }

    @PostMapping(value={"/Admin/connexion/rech"})
    public ResponseEntity<ConnexionAdminDTO> rechercherConnexion(@RequestParam(value="rech") String rech, @RequestParam(defaultValue="0") String pageNumber) throws JsonProcessingException {
        return this.adminService.rechercherConnexion(rech, Integer.parseInt(pageNumber));
    }

    @PutMapping(value={"/Admin/deconnexion/{idconnexion}"})
    public String DeconnecterAdmin(@PathVariable(value="idconnexion") Long idconnexion) throws ParseException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9connexion de l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.Deconnexion(idconnexion);
    }

    @GetMapping(value={"/Admin/articles"})
    public ResponseEntity<List<ArticlesAdminDto>> getAllArticles() throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de tous les articles par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAllArticles();
    }

    @PutMapping(value={"/Admin/desactiverarticle"})
    public String DeactivateArticle(@RequestParam(value="id") String id) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9sactivation d'un article par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.DeactivateArticle(id);
    }

    @PutMapping(value={"/Admin/desactiverarticles"})
    public String DeactivateArticles(@Validated @RequestBody List<Long> ids) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9sactivation de plusieurs articles par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.DeactivateArticles(ids);
    }

    @PutMapping(value={"/Admin/reactiverarticle"})
    public String ReactivateArticle(@RequestParam(value="id") String id) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9activation d'un article par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.ReactivateArticle(id);
    }

    @PutMapping(value={"/Admin/reactiverarticles"})
    public String ReactivateArticles(@Validated @RequestBody List<Long> ids) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9activation de plusieurs articles par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.ReactivateArticles(ids);
    }

    @GetMapping(value={"/Admin/auteurs"})
    public ResponseEntity<List<AuteurAdminDto>> getAllAuteur() throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de tous les comptes par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAllAuteur();
    }

    @PostMapping(value={"/Admin/auteurs/rech"})
    public ResponseEntity<AuteurAdminDtoWithPages> RechercherAuteur(@RequestParam(value="rech") String rech, @RequestParam(defaultValue="0") String pageNumber) throws JsonProcessingException {
        return this.adminService.RechercherAuteur(rech, Integer.parseInt(pageNumber));
    }

    @PostMapping(value={"/Admin/auteur"})
    public Auteur CreateAuteur(@Validated @RequestBody Auteur auteur) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Cr\u00e9ation d'un compte contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.CreateAuteur(auteur);
    }

    @PutMapping(value={"/Admin/pwdauteur"})
    public String UpdatePasswordAuteur(@RequestParam(value="id") String id, @RequestParam(value="newpwd") String newpwd) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Modification du mot de passe d'un compte contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.UpdatePasswordAuteur(id, newpwd);
    }

    @PutMapping(value={"/Admin/monetisation/{id}"})
    public String Updatemonetisation(@PathVariable(value="id") Long id, @RequestParam(value="etat") String etat) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("Modification de la mon\u00e9tisation d'un compte par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.Updatemonetisation(id, etat);
    }

    @PutMapping(value={"/Admin/bloquerauteur"})
    public String BloquerAuteur(@RequestParam(value="id") String id) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9sactivation d'un compte contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.BloquerAuteur(id);
    }

    @PutMapping(value={"/Admin/reactiverauteur"})
    public String ResactiverAuteur(@RequestParam(value="id") String id) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9activation d'un compte contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.ReactiverAuteur(id);
    }

    @PutMapping(value={"/Admin/bloquerauteurs"})
    public String BloquerAuteurs(@Validated @RequestBody List<Long> ids) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("D\u00e9sactivation de plusieurs comptes contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.BloquerAuteurs(ids);
    }

    @PutMapping(value={"/Admin/reactiverauteurs"})
    public String ResactiverAuteurs(@Validated @RequestBody List<Long> ids) {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9activation de plusieurs comptes contributeur par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.ReactiverAuteurs(ids);
    }

    @PostMapping(value={"/Admin/delete/{id}"})
    public String deleteCompte(@PathVariable(value="id") Long id) {
        return this.adminService.deleteCompte(id);
    }

    @PostMapping(value={"/Admin/SeConnecterAuCompteAuteur"})
    public UserInfoResponse SeConnecterAuCompteAuteur(@RequestParam(value="username") String username, @RequestParam(value="pwd") String pwd) {
        return this.adminService.SeConnecterAuCompteAuteur(username, pwd);
    }

    @PostMapping(value={"/Admin/getAllAuteurPwdDtos"})
    public ResponseEntity<AuteurPwdDTOWithPages> getAllAuteurPwdDtos(@RequestParam(defaultValue="0") String pageNumber) throws JsonProcessingException {
        return this.adminService.getAllAuteurPwdDtos(Integer.parseInt(pageNumber));
    }

    @PostMapping(value={"/Admin/getAllAuteurPwdDtos/rech"})
    public ResponseEntity<AuteurPwdDTOWithPages> RechercherAuteurPwdDtos(@RequestParam(value="rech") String rech, @RequestParam(defaultValue="0") String pageNumber) throws JsonProcessingException {
        return this.adminService.RechercherAuteurPwdDtos(rech, Integer.parseInt(pageNumber));
    }

    @GetMapping(value={"/Admin/dashboard"})
    public ResponseEntity<List<DashbordStats>> getAdminDashboardStats() throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des donn\u00e9es du tableau de bord admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAdminDashboardStats();
    }

    @PostMapping(value={"/Admin/statistiques"})
    public ResponseEntity<StatistiqueArticleDTO> getAdminStatistiques(@RequestParam(defaultValue="0") String pageNumber) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de toutes les statistiques par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAdminStatistiques(Integer.parseInt(pageNumber));
    }

    @PostMapping(value={"/Admin/statistiques/rech"})
    public ResponseEntity<StatistiqueArticleDTO> RechercherArticlesStatistiques(@RequestParam(value="rech") String rech, @RequestParam(defaultValue="0") String pageNumber) throws IOException {
        return this.adminService.RechercherArticlesStatistiques(rech, Integer.parseInt(pageNumber));
    }

    @PostMapping(value={"/Admin/bugs"})
    public ResponseEntity<BugDTO> getAllBugs(@RequestParam(defaultValue="0") String pageNumber) throws JsonProcessingException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration de tous les bugs par l'admin");
        System.out.println("-------------------------------------------------------------------------------");
        return this.adminService.getAllBugs(Integer.parseInt(pageNumber));
    }

    @PostMapping(value={"/Admin/recommandations"})
    public ResponseEntity<RecommandationAdminDTO> getAllRecommandations(@RequestParam(defaultValue="0") String pageNumber) throws JsonProcessingException {
        return this.adminService.getAllRecommandations(Integer.parseInt(pageNumber));
    }

    @GetMapping(value={"/Admin/getAllPaiements"})
    public ResponseEntity<List<PaiementAdmin>> getAllPaiements() throws JsonProcessingException {
        return this.adminService.getAllPaiements();
    }

    @PostMapping(value={"/Admin/addpaiement"})
    public ResponseEntity<List<PaiementAdmin>> ajouterPaiementAdmin(@Validated @RequestBody PaiementAdmin paiementAdmin) throws JsonProcessingException {
        return this.adminService.ajouterPaiementAdmin(paiementAdmin);
    }

    @GetMapping(value={"/Admin/getTransactions/{id}"})
    public ResponseEntity<List<Transaction>> getTransactionsByPaiementAdmin(@PathVariable(value="id") Long id) throws JsonProcessingException {
        return this.adminService.getTransactionsByPaiementAdmin(id);
    }

    @PutMapping(value={"/Admin/UpdateBudget"})
    public ResponseEntity<List<PaiementAdmin>> UpdateBudget(@Validated @RequestBody PaiementAdmin paiementAdmin) throws JsonProcessingException {
        return this.adminService.UpdateBudget(paiementAdmin);
    }

    @PutMapping(value={"/Admin/UpdateMontantsTransactions"})
    public String UpdateMontantsTransactions(@Validated @RequestBody List<Transaction> transactionList) {
        return this.adminService.UpdateMontantsTransactions(transactionList);
    }

    @PutMapping(value={"/Admin/ConfirmMontantsTransactions"})
    public String ConfirmMontantsTransactions(@Validated @RequestBody List<Transaction> transactionList) {
        return this.adminService.ConfirmMontantsTransactions(transactionList);
    }

    @PutMapping(value={"/Admin/ConfirmMontantsDigimp"})
    public String ConfirmMontantsDigimp(@Validated @RequestBody List<Transaction> transactionList) {
        return this.adminService.ConfirmMontantsDigimp(transactionList);
    }

    @DeleteMapping(value={"/Admin/paiement/{id}"})
    public String DeletePaiement(@PathVariable(value="id") Long id) {
        return this.adminService.DeletePaiement(id);
    }

    @PostMapping(value={"/Admin/requete"})
    public ResponseEntity<List<AuteurRequeteDTO>> getResultatRequete(@Validated @RequestBody RequeteDTO requeteDTO) throws ParseException, JsonProcessingException {
        return this.adminService.getResultatRequete(requeteDTO);
    }

    @PostMapping(value={"/Admin/messages"})
    public String EnregitrerMessages(@Validated @RequestBody MessageDTO messageDTO) {
        return this.adminService.EnregitrerMessages(messageDTO);
    }

    @GetMapping(value={"/Admin/messages"})
    public ResponseEntity<List<Message>> getMessagesEnvoyer() throws JsonProcessingException {
        return this.adminService.getMessagesEnvoyer();
    }
}

